: INFORMATION

: Title: ASR - Auto Server Restart

: Version: 0.1

: Game: Quake 3 Arena

: Operating System: Windows

: Author: HuXX

: Year: 2009

: URL: www.bmamod.6x.to


: DISCLAIMER

: The User accepts that HuXX and representatives of any kind cannot be held responsible or be liable for any damages, costs, loss or expenses arising directly or indirectly, because the User was using ASR - Auto Server Restart.

: The User accepts that he use ASR - Auto Server Restart at his own risk.


: LICENSE

: ASR - Auto Server Restart with all parts are completely free.

: ASR - Auto Server Restart may be used on any computers.

: ASR - Auto Server Restart must not be modified.

: ASR - Auto Server Restart may be passed on others, selling is forbidden.

: ASR - Auto Server Restart may be passed on others, when ASR - Auto Server Restart or its parts must not be modified.




:ASR_START

@ECHO OFF
title ASR 0.1 - CLOSE THIS WINDOW BEFORE YOU SHUTDOWN THE SERVER
cls
ECHO ------------------------------------------------------------
ECHO   Quake 3 Arena Server Auto Restart 0.1 - www.bmamod.6x.to 
ECHO ------------------------------------------------------------
ping -n 2 localhost>nul


:CHECK_Q3_EXE
ECHO.
ECHO Searching quake3.exe
ping -n 2 localhost>nul


:Q3_EXE_NOT_EXIST

IF NOT EXIST QUAKE3.EXE goto ERROR_Q3_EXE


:Q3_EXE_EXIST

IF EXIST QUAKE3.EXE ECHO OK
ping -n 2 localhost>nul
ping -n 2 localhost>nul
GOTO CHECK_SETTINGS_BAT


:CHECK_SETTINGS_BAT

cls
ECHO ------------------------------------------------------------
ECHO   Quake 3 Arena Server Auto Restart 0.1 - www.bmamod.6x.to 
ECHO ------------------------------------------------------------
ECHO.
ECHO Loading Settings
ping -n 2 localhost>nul


:SETTINGS_EXIST

IF EXIST Settings_ASR_0.1.bat goto LOAD_SETTINGS


:SETTINGS_NOT_EXIST

IF NOT EXIST Settings_ASR_0.1.bat goto LOAD_INSTALLER


:LOAD_INSTALLER

ECHO Not Found
ping -n 2 localhost>nul
ping -n 2 localhost>nul
cls
ECHO ------------------------------------------------------------
ECHO   Quake 3 Arena Server Auto Restart 0.1 - www.bmamod.6x.to 
ECHO ------------------------------------------------------------
ECHO.
ECHO Loading Installer
ping -n 2 localhost>nul
ECHO OK
ping -n 2 localhost>nul
ping -n 2 localhost>nul
cls
ECHO ------------------------------------------------------------
ECHO   Quake 3 Arena Server Auto Restart 0.1 - www.bmamod.6x.to 
ECHO ------------------------------------------------------------
goto CHECK_SETTINGS


:CHECK_SETTINGS


:CHECK_SETTINGS_MODFOLDER

ECHO.
set modfolder=
set /p modfolder=Enter the name of the mod folder (Example: BMA):
if  "%modfolder%"=="" goto CHECK_SETTINGS_MODFOLDER
if not "%modfolder%"=="" goto CHECK_SETTINGS_SERVERCONFIG


:CHECK_SETTINGS_SERVERCONFIG

ECHO.
set serverconfig=
set /p serverconfig=Enter the name of the server config file (Example: default.cfg):
if  "%serverconfig%"=="" goto CHECK_SETTINGS_SERVERCONFIG
if not "%serverconfig%"=="" goto CHECK_SETTINGS_MEMORY


:CHECK_SETTINGS_MEMORY

ECHO.
set servermemory=
set /p servermemory=Enter the maximum memory usage (in MB) for the server (Example: 56):
if  "%servermemory%"=="" goto CHECK_SETTINGS_SERVERMEMORY
if not "%servermemory%"=="" goto CHECK_SETTINGS_RESTARTLOG


:CHECK_SETTINGS_RESTARTLOG

ECHO.
set restartlog=
set /p restartlog=Enter the name of the restart log file (Example: restart.log):
if  "%restartlog%"=="" goto CHECK_SETTINGS_RESTARTLOG
if not "%restartlog%"=="" goto CHECK_SETTINGS_AGAIN


:CHECK_SETTINGS_AGAIN

ECHO.
set check=
set /p check=Do you wanna change something again (YES / NO) :
if  "%check%"=="y" goto CHECK_SETTINGS
if  "%check%"=="Y" goto CHECK_SETTINGS
if  "%check%"=="yes" goto CHECK_SETTINGS
if  "%check%"=="YES" goto CHECK_SETTINGS
if  "%check%"=="Yes" goto CHECK_SETTINGS
if  "%check%"=="n" goto CREATE_FILE
if  "%check%"=="N" goto CREATE_FILE
if  "%check%"=="no" goto CREATE_FILE
if  "%check%"=="NO" goto CREATE_FILE
if  "%check%"=="No" goto CREATE_FILE
if  "%check%"=="" goto CHECK_SETTINGS_AGAIN
GOTO CHECK_SETTINGS_AGAIN

:CREATE_FILE

cls
ECHO ------------------------------------------------------------
ECHO   Quake 3 Arena Server Auto Restart 0.1 - www.bmamod.6x.to 
ECHO ------------------------------------------------------------
ECHO.
ECHO Create Settings File
ping -n 2 localhost>nul
ECHO.

ECHO Settings_ASR_0.1.bat
ECHO :Name of the mod folder (Example: BMA)>Settings_ASR_0.1.bat
ECHO SET modfolder=%modfolder%>>Settings_ASR_0.1.bat
ECHO.>>Settings_ASR_0.1.bat
ECHO :Name of the server config file (Example: default.cfg)>>Settings_ASR_0.1.bat
ECHO SET serverconfig=%serverconfig%>>Settings_ASR_0.1.bat
ECHO.>>Settings_ASR_0.1.bat
ECHO :Maximum memory usage (in MB) for the server (Example: 56)>>Settings_ASR_0.1.bat
ECHO SET servermemory=%servermemory%>>Settings_ASR_0.1.bat
ECHO.>>Settings_ASR_0.1.bat
ECHO :Name of the restart log file (Example: restart.log)>>Settings_ASR_0.1.bat
ECHO SET restartlog=%restartlog%>>Settings_ASR_0.1.bat
ECHO OK
ping -n 2 localhost>nul

goto CHECK_SETTINGS_BAT
 
 
:LOAD_SETTINGS

call Settings_ASR_0.1.bat
ECHO.
ECHO Mod Folder: %modfolder%
ping -n 2 localhost>nul
ECHO Server Config File: %serverconfig%
ping -n 2 localhost>nul
ECHO Maximum Memory Usage: %servermemory% MB
ping -n 2 localhost>nul
ECHO Restart Log File: %restartlog%
ping -n 2 localhost>nul
ECHO.
ECHO OK
ping -n 2 localhost>nul
ping -n 2 localhost>nul
goto START_SERVER


:START_SERVER

cls
ECHO ------------------------------------------------------------
ECHO   Quake 3 Arena Server Auto Restart 0.1 - www.bmamod.6x.to 
ECHO ------------------------------------------------------------
ECHO.
ECHO ------------------------------------------------------------
ECHO   \/ Status \/ Time \/ Date \/
ECHO ------------------------------------------------------------
ping -n 2 localhost>nul
ECHO   Start Server
ECHO.
ping -n 2 localhost>nul
ping -n 2 localhost>nul
ECHO   Server Started %time:~0,2%:%time:~3,2% %date%
ECHO.


:SERVERLOOP

quake3.exe +set fs_game %modfolder% +set dedicated 2 +set com_hunkmegs %servermemory% +exec %serverconfig%
ECHO   Server Restarted %time:~0,2%:%time:~3,2% %date%
ECHO %time:~0,2%:%time:~3,2% %date% >> %restartlog%
ECHO.

GOTO SERVERLOOP


:ERROR_Q3_EXE

ECHO.
ECHO Cant find quake3.exe. 
ECHO ASR_0.1.bat must be located in your quake 3 folder (../quake3/ASR_0.1.bat).
ECHO Close this window and try it again.
ECHO.
GOTO ASR_END


:ASR_END

pause